<?php

define('API_URL', 'https://secure.wizard.ca/generator/newgenerator.php');
define('API_CLIENT', 'go8aeCul');
define('USER_AGENT', 'mthreat_api_client/1.0');

class mthreatAPI {

    //! the email login for the reseller
    private $m_strEmail;

    //! the password for the reseller
    private $m_strPassword;

    //! the API code for the reseller
    private $m_strApiCode;

    //! buffer for error messages
    private $m_strLastError;

    public function __construct($login, $pwd, $code) {
        if (  !isset($login)
           || !is_string($login)
           || !strlen(trim($login))
           || !isset($pwd)
           || !is_string($pwd)
           || !strlen(trim($pwd))
           || !isset($code)
           || !is_string($code)
           || !strlen(trim($code)) )  {
            throw new Exception("Invalid credentials for API connection");
        }

        $this->m_strEmail = trim($login);
        $this->m_strPassword = trim($pwd);
        $this->m_strApiCode = trim($code);
    }

    public function getLastError() {
        return $this->m_strLastError;
    }

    public function test() {
        return $this->runAPI('test');
    }

    public function loadProducts($type = NULL) {
        $fields = NULL;
        if (is_string($type) && strlen(trim($type)) > 0) {
            $fields['skutype'] = $type;
        }
        return $this->runAPI('fetch_skus', $fields);
    }

    public function loadSummary() {
        return $this->runAPI('fetch_summary');
    }

    public function newLicense($fields) {
        return $this->runAPI('new_license', $fields);
    }

    public function renewLicense($fields) {
        return $this->runAPI('renew_license', $fields);
    }

    public function fetchLicense($clientid, $orderid, $serviceid) {
        // prep the fields
        $fields = [
            'client_id' => intval($clientid),
            'order_id' => intval($orderid),
            'service_id' => intval($serviceid)
        ];
        return $this->runAPI('fetch_license', $fields);
    }

    public function terminateLicense($clientid, $orderid, $serviceid) {
        $fields = [
            'client_id' => intval($clientid),
            'order_id' => intval($orderid),
            'service_id' => intval($serviceid)
        ];
        return $this->runAPI('terminate_license', $fields);
    }

    //! method to run an API call.
    private function runAPI($action, $fields = NULL) {
        // TODO: validate arguments.

        // TODO: run in a fork in order to control timeout

        // initialize a handle to the end point.
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, API_URL);

        // set the custom user agent
        curl_setopt($ch, CURLOPT_USERAGENT, USER_AGENT);

        curl_setopt($ch, CURLOPT_POST, 1);  // equivalent to curl -X POST

        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE); // temporary while testing - equivalent to curl -k
        curl_setopt($ch, CURLOPT_SSL_VERIFYSTATUS, FALSE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);

        // this tells curl to return the result, not print it out.
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE); 

        // set the custom headers
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'X-API-CLIENT: ' . API_CLIENT,
            'Content-Type: application/json'
        ]);

        // set the authentication
        //curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_ANY);
        curl_setopt($ch, CURLOPT_USERNAME, $this->m_strEmail);
        curl_setopt($ch, CURLOPT_PASSWORD, $this->m_strPassword);

        $payload = [
            'RESELLER_CODE' => $this->m_strApiCode,
            'action' =>  $action
        ];
        if (is_array($fields)) {
            foreach ($fields as $key => $dat) {
                $payload[$key] = $dat;
            }
        }

        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));

        // run the call.
        $result = curl_exec($ch);

        if ($result === FALSE) {
            $resinfo = curl_getinfo($ch, CURLINFO_TEXT);
            $this->m_strLastError = $resinfo;
        }
            

        // close the connection
        curl_close($ch);

        // and return.
        return $result;
    }
}
