<?php

//! guard to make sure this only works within WHMCS system.
if (!defined("WHMCS")) {
    die("This file cannot be accessed directly");
}

use WHMCS\Database\Capsule ;

require_once('lib/lib.mthreat_api.php');

//! defines the addon details, and provides configuration fields
/*!
 * @return  array       the configuration for this module.
 *
 * NOTE: the 'fields' are displayed on the System Settings -> Apps &
 *       Integrations -> Addon Modules -> Configure interface of
 *       the admin portal.
 *
 *       This interface will also natively provide the ability to configure
 *       what roles are permitted to access the module itself (via 'Addons'
 *       menu - think of this as a master level interface).
 *
 *       It should be noted that while Locales are supported in general, they are
 *       not supported here (eg: we cannot set the module description different
 *       based on language).
 *
 *       I was surprised to find that the description field permitted markup...
 *       that may be removed in future once WHMCS does security audits,
 *       but for now I will take advantage of this.
 *
 *       The 'intro' field, I was not able to find it being displayed anywhere.....
 */
function magicspam_reseller_config() {
    $config = [
        'name' => 'MagicSpam Reseller Addon',
        'intro' => 'Provisioning Connector to the MagicSpam Reseller system',
        'description' => 'This addon connects your WHMCS installation with your MagicSpam Reseller portal.  This allows you to easily resell MagicSpam and/or other mThreat product licenses, as a configurable option which can be bundled with your existing offerings, or sold as a separate product. Log into your <a href="https://secure.wizard.ca/resellers" target="_NEW"><b>reseller portal</b></a> and click on the Integration tab for details of what to set in the configuration below.',
        'documentation' => 'https://www.magicspam.com',
        'language' => 'english',
        'version' => '1.0',
        'author' => 'mThreat Technology Inc.',
        'fields' => [
            'ms_reseller_code' => [
                'FriendlyName' => 'MagicSpam Reseller Code',
                'Type' => 'text',
                'Size' => 25,
            ],
            'ms_reseller_email' => [
                'FriendlyName' => 'MagicSpam Reseller Email',
                'Type' => 'text',
                'Size' => 25,
            ],
            'ms_reseller_password' => [
                'FriendlyName' => 'MagicSpam Reseller Password',
                'Type' => 'password',
                'Size' => 25,
            ],
        ],
    ];
    return $config;
}

//! function to render Admin area module main page (Top menu 'Addons' drop down).
/*!
 * @param   array   the keyed array of information for the module.
 *
 * The argument will contain standard information:
 *
 *  * 'module' => 'string' - the backend name of this module eg: magicspamreseller_addon
 *  * 'modulelink' => 'string' - the URL for any sort of POST actions to stay on this page.
 *  * 'version' => 'string' - the version of this module.
 *  * 'access' => 'int' - 1 to indicate access is allowed, otherwise 0 if someone tried to
 *                        hack in: whmcs prevents access natively though so this seems pointless.
 *
 * In addition, this will also contain the 'custom' fields (and values) set from the
 * configuration defined in function magicspamreseller_addon_config.
 *
 * And, if there are 'lang' files set, then $vars will also contain an array of the
 * $_ADDONLANG variables via a key [_lang] => Array ( 'key' => 'value').
 *
 * Languages supported (out of the set we are interested in):
 *
 *
 *  * english
 *  * dutch
 *  * portuguese-br
 *  * spanish
 *
 *  No german... though they have a german file... we might as well, just doesn't
 *  seem to exist as a selectable option for 'user' options on the admin side.. but
 *  does on the default language general settings configuration... weird....
 */
function magicspam_reseller_output($vars) {

    $lang = $vars['_lang'];

    $errorstring = handleSettings($vars);

    // render the stylesheet - required for all views paths.
    include('views/stylesheet.html');

    // test that the API is accessible.
    $api_good = FALSE;
    $statuserror = $lang['settings_invalid'];

    try {
        $api = new mthreatAPI(
            $vars['ms_reseller_email'],
            $vars['ms_reseller_password'],
            $vars['ms_reseller_code']);

        // using 'do/while' to prevent overly deep if/else nesting.
        do {
            $rc = $api->test();
            if ($rc === FALSE) {
                $statuserror = $api->getLastError();
                $api_good = FALSE;
                break;
            }

            $res = json_decode($rc, TRUE);
            if (  !isset($res['status'])
               || $res['status'] === FALSE) {

                $statuserror = $lang['settings_save_authfail']
                    . ":["
                    . $res['statuscode']
                    . "] "
                    . $res['message'];
                $api_good = FALSE ;
                break;
            }
            if ($res['status'] === TRUE) {
                $api_good = TRUE;
                $statuserror = '';
            }
        } while (0);
    } catch (Exception $e) {
        // the only way this can / should happen is if one of the
        // credentials settings is empty.
        // the statuserror and status variables are already set for
        // that.
    }

    if ($api_good) {
        // try to load the reseller summary information.
        $summary = $api->loadSummary();
        
        if (  !is_string($summary)
           || ! ($summary_arr = json_decode($summary, TRUE))
           || !isset($summary_arr['status']) ) {
            $statuserror = "Unknown error retrieving Reseller account summary: " . $summary;
            include('views/apiinvalid.html');
        } else {
            if (!$summary_arr['status']) {
                $statuserror = $summary_arr['message'];
                include('views/apiinvalid.html');
            } else {
                $data = $summary_arr['data'];
                include('views/dashboard.html');
            }
        }
    } else {
        include('views/apiinvalid.html');
    }

    // render the information blurb.
    include('views/info_blurb.html');

    // render module settings form.
    include('views/settings.html');

    // and a footer.
    include('views/footer.html');
}

//-----------------------------------------------------------------------------
// NON module functions used for internal processing
//-----------------------------------------------------------------------------

//! method to handle any module settings changes
/*!
 * @param   arrayref    the output vars - we may need to change them.
 *
 * @return  string      any error output that may need to be displayed.
 */
function handleSettings(&$vars) {
    $errorstring = '';

    $lang = $vars['_lang'];

    // POST processing
    // NOTE: I am aware there are ternary operators that can shorten
    //       this assignment, but those operators only become available in
    //       newer versions of PHP.  To ensure compatibility, we will use old
    //       school method that is known to work.
    $action = isset($_POST['msaction']) ? $_POST['msaction'] : '';

    switch ($action) {
    case 'update_settings':
        if (  !isset($_POST['ms_reseller_code'])
           || !isset($_POST['ms_reseller_email'])
           || !isset($_POST['ms_reseller_password'])  ) {
            // do nothing, assume someone was trying to screw around.
            break;
        }

        // the password may or may not be set.
        $password = $vars['ms_reseller_password'];
        if (  isset($_POST['ms_reseller_password'])
           && strlen(trim($_POST['ms_reseller_password'])) > 0) {
            $password = trim($_POST['ms_reseller_password']);
        }

        // test that the API connection works with posted credentials.
        try {
            $api = new mthreatAPI(
                            trim($_POST['ms_reseller_email']),
                            $password,
                            trim($_POST['ms_reseller_code']));
            $rc = $api->test();
            if ($rc === FALSE) {
                $errorstring = $lang['settings_save_authfail'] . ':  '
                    . $api->getLastError();
                break;
            }
            $res = json_decode($rc, TRUE);
            if (  !isset($res['status'])
               || $res['status'] === FALSE) {
                $errorstring = $lang['settings_save_authfail']
                    . ":["
                    . $res['statuscode']
                    . "] "
                    . $res['message'];
                break;
            }
        } catch (Exception $e) {
            $errorstring = $lang['settings_save_noapi'] . ": "
                . $e->getMessage();
            break;
        }

        // try to fetch a database connection
        $pdo = Capsule::connection()->getPdo();
        if (!is_a($pdo, 'PDO')) {
            $errorstring = $lang['settings_save_nodb'];
            break;
        }
        // using HEREDOC syntax for legibility...
        $query =<<<END
UPDATE tbladdonmodules SET
    value=?
WHERE
    module=?
AND
    setting=?
END;
        $pdo->beginTransaction();

        try {
            $sth = $pdo->prepare($query);
        } catch (Exception $e) {
            $errorstring = $e->getMessage();
        }

        // use a 'do while' to avoid deep if/else nesting...
        $success = FALSE;
        do {
            try {
                if (!$sth->execute(
                    [
                        trim($_POST['ms_reseller_code']),
                        $vars['module'],
                        'ms_reseller_code'
                    ])) {
                    $pdo->rollback();
                    $errorstring = $lang['settings_save_error'];
                    break;
                }
            } catch (Exception $e) {
                $errorstring = $e->getMessage();
                $pdo->rollback();
                break;
            }

            try {
                if (!$sth->execute(
                    [
                        trim($_POST['ms_reseller_email']),
                        $vars['module'],
                        'ms_reseller_email'
                    ])) {
                    $pdo->rollback();
                    $errorstring = $lang['settings_save_error'];
                    break;
                }
            } catch (Exception $e) {
                $errorstring = $e->getMessage();
                $pdo->rollback();
                break;
            }

            // only update the password if that was provided.
            if (strlen(trim($_POST['ms_reseller_password'])) > 0) {
                try {
                    if (!$sth->execute(
                        [
                            trim($_POST['ms_reseller_password']),
                            $vars['module'],
                            'ms_reseller_password'
                        ])) {
                        $pdo->rollback();
                        $errorstring = $lang['settings_save_error'];
                        break;
                    }
                } catch (Exception $e) {
                    $errorstring = $e->getMessage();
                    $pdo->rollback();
                    break;
                }
            }

            $success = TRUE;

        } while (0);

        if ($success) {
            $pdo->commit();
            $vars['ms_reseller_code'] = trim($_POST['ms_reseller_code']);
            $vars['ms_reseller_email'] = trim($_POST['ms_reseller_email']);

            if (strlen(trim($_POST['ms_reseller_password'])) > 0) {
                $vars['ms_reseller_password'] = trim($_POST['ms_reseller_password']);
            }
        }
        break;
    default:
        return '';
        break;
    }

    if (!strlen($errorstring)) {
        $errorstring = '<div class="success">'
                     . htmlspecialchars($lang['settings_save_success'])
                     . '</div>';
    } else {
        $errorstring = '<div class="error">'
                     . $errorstring
                     . '</div>';
    }
    return $errorstring;
}

